/*
 * Decompiled with CFR 0.152.
 */
package bird.util;

public class PwrConv {
    private static final double DB_LIMIT = -60.0;

    public static double compRho(double d, double d2) {
        return d == 0.0 ? 1.0 : Math.sqrt(d2 / d);
    }

    public static double Watts2dBm(double d) {
        return d == 0.0 ? -60.0 : 10.0 * PwrConv.log10(d) + 30.0;
    }

    public static double mRho2Rho(double d) {
        return d / 1000.0;
    }

    public static double Rho2VSWR(double d) {
        double d2 = PwrConv.RhoLimits(d);
        return PwrConv.VSWRLimits((1.0 + d2) / (1.0 - d2));
    }

    public static double Rho2RL(double d) {
        return PwrConv.RLLimits(20.0 * PwrConv.log10(PwrConv.RhoLimits(d)));
    }

    public static double VSWR2Rho(double d) {
        return PwrConv.RhoLimits((d - 1.0) / (d + 1.0));
    }

    public static double VSWR2RL(double d) {
        return PwrConv.VSWRLimits(PwrConv.Rho2RL(PwrConv.VSWR2Rho(d)));
    }

    public static double RL2Rho(double d) {
        return PwrConv.RhoLimits(Math.pow(10.0, d / 20.0));
    }

    public static double RL2VSWR(double d) {
        return PwrConv.Rho2VSWR(PwrConv.RL2Rho(d));
    }

    public static double calcTransPwr(double d, double d2) {
        return d == 0.0 ? 0.0 : 100.0 * (1.0 - d2 / d);
    }

    private static double log10(double d) {
        return Math.log(d) / Math.log(10.0);
    }

    private static double RhoLimits(double d) {
        double d2 = d;
        if (d2 >= 1.0) {
            d2 = 0.99999;
        }
        if (d2 < 0.0) {
            d2 = 0.0;
        }
        return d2;
    }

    private static double VSWRLimits(double d) {
        double d2 = d;
        if (d2 > 99.99) {
            d2 = 99.99;
        }
        if (d2 < 1.0) {
            d2 = 1.0;
        }
        return d2;
    }

    private static double RLLimits(double d) {
        double d2 = d;
        if (d2 > 0.0) {
            d2 = 0.0;
        }
        if (d2 < -60.0) {
            d2 = -60.0;
        }
        return d2;
    }
}

